//=============================================================================
// MSTurretWindow.
//=============================================================================
class MSTurretWindow expands MenuUIWindow;

var MenuUIActionButtonWindow okButton;
var MenuUIActionButtonWindow exitButton;
var MenuUIEditWindow DamageWindow;
var MenuUIEditWindow FireRateWindow;
var MenuUIEditWindow SelTagWindow;
var MenuUIEditWindow SelTitleWindow;
var MenuUIHeaderWindow winText;
var localized string okButtonText;
var localized string exitButtonText;
var MSUtilityGun _windowOwner;
var string gunDamage;
var string fireRate;
var string SelTag;
var string SelTitle;

event InitWindow()
{
   local Window W;

   Super.InitWindow();

   winClient.SetBackground(Texture'DeusExUI.MaskTexture');
   winClient.SetBackgroundStyle(DSTY_Modulated);

   W = winClient.NewChild(Class'Window');
   W.SetSize(ClientWidth, ClientHeight);
   W.SetBackground(Texture'DeusExUI.MaskTexture');
   W.SetBackgroundStyle(DSTY_Modulated);
   W.Lower();

   DamageWindow = CreateMenuEditWindow(60, 15, 70, 30, winClient);
   FireRateWindow = CreateMenuEditWindow(130, 15, 70, 30, winClient);
   SelTagWindow = CreateMenuEditWindow(60, 45, 70, 30, winClient);
   SelTitleWindow = CreateMenuEditWindow(130, 45, 70, 30, winClient);

   okButton = winButtonBar.AddButton(okButtonText, HALIGN_Right);
   exitButton = winButtonBar.AddButton(exitButtonText, HALIGN_Left);

  if (Player.Weapon.IsA('MSUtilityGun'))
   {
     _WindowOwner = MSUtilityGun(Player.Weapon);
   }

  /*if ((_WindowOwner != None) && (_WindowOwner.Selected.IsA('AutoTurret')))
  {
   gunDamage = AutoTurret(_WindowOwner.Selected).gunDamage;
   fireRate = AutoTurret(_WindowOwner.Selected).FireRate;
   SelTag = AutoTurret(_WindowOwner.Selected).Tag;
   SelTitle = AutoTurret(_WindowOwner.Selected).titleString;
  }

   DamageWindow.setText(""$gunDamage$"");
   FireRateWindow.setText(""$fireRate$"");
   SelTagWindow.setText(""$SelTag$"");
   SelTitleWindow.setText(""$SelTitle$"");*/
   SetTitle("Damage,Rate,Tag,Name");
}

function SetGoodies(AutoTurret Selected)
{
   gunDamage = Selected.GetPropertyText("gunDamage");
   fireRate = Selected.GetPropertyText("fireRate");
   SelTag = Selected.GetPropertyText("Tag");
   SelTitle = Selected.GetPropertyText("TitleString");

   DamageWindow.setText(""$gunDamage$"");
   FireRateWindow.setText(""$fireRate$"");
   SelTagWindow.setText(""$SelTag$"");
   SelTitleWindow.setText(""$SelTitle$"");
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch( buttonPressed )
	{
		case okButton:
			_windowOwner.setTurret(int(DamageWindow.GetText()), float(FireRateWindow.GetText()), SelTagWindow.GetText(), SelTitleWindow.GetText());
			root.PopWindow();
			bHandled = True;
			break;

		case exitButton:
			// Do stuff
			root.PopWindow();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	return bHandled;
}

defaultproperties
{
     okButtonText="Ok"
     exitButtonText="Cancel"
     ClientWidth=350
     ClientHeight=85
     clientTextures(0)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_2'
     textureRows=1
     textureCols=2
     bActionButtonBarActive=True
     bUsesHelpWindow=False
     winShadowClass=Class'DeusEx.MenuUIMessageBoxShadowWindow'
}
